% AmirHosein Sadeghimanesh
% 2020 February, modified 2021 August
%
% This script plots the results of the Julia file 
% "Julia_section_5_2_applying_algorithm_1_using_Kac_Rice_integral.jl".
% These plots are the parts d, e and f of Figure 8 of the paper.
%
B = [0, 5; 0, 5]; % The parameter region.
%
% Figure 8d.
%
K = [2.5, 2.5, 5.0, 5.0]; % Rectangles with 3 solutions.
L = [0.0, 0.0, 2.5, 2.5;
    0.0, 2.5, 2.5, 5.0;
    2.5, 0.0, 5.0, 2.5]; % Rectangles with 1 solutions.
% generating the plot.
bisect2valuedRecPlot(B, K, L)
%
% Figure 8e.
%
K = [2.5, 2.5, 3.75, 3.75;
    3.75, 2.5, 5.0, 3.75;
    3.75, 3.75, 5.0, 5.0]; % Rectangles with 3 solutions.
L = [0.0, 2.5, 2.5, 5.0;
    0.0, 0.0, 1.25, 2.5;
    3.75, 0.0, 5.0, 2.5;
    1.25, 0.0, 2.5, 1.25;
    1.25, 1.25, 2.5, 2.5;
    2.5, 0.0, 3.75, 1.25;
    2.5, 1.25, 3.75, 2.5;
    2.5, 3.75, 3.75, 5.0]; % Rectangles with 1 solutions.
% generating the plot.
bisect2valuedRecPlot(B, K, L)
%
% Figure 8f.
%
K = [3.75, 2.5, 5.0, 3.75;
    1.25, 1.25, 1.875, 1.875;
    1.875, 1.875, 2.5, 2.5;
    2.5, 1.875, 3.125, 2.5;
    3.125, 1.875, 3.75, 2.5;
    2.5, 2.5, 3.125, 3.125;
    3.125, 2.5, 3.75, 3.125;
    3.125, 3.125, 3.75, 3.75;
    3.75, 3.75, 4.375, 4.375;
    4.375, 3.75, 5.0, 4.375;
    4.375, 4.375, 5.0, 5.0]; % Rectangles with 3 solutions.
L = [0.0, 2.5, 2.5, 5.0;
    0.0, 0.0, 1.25, 2.5;
    3.75, 0.0, 5.0, 2.5;
    1.25, 0.0, 2.5, 1.25;
    2.5, 0.0, 3.75, 1.25;
    2.5, 3.75, 3.75, 5.0;
    1.25, 1.875, 1.875, 2.5;
    1.875, 1.25, 2.5, 1.875;
    2.5, 1.25, 3.125, 1.875;
    3.125, 1.25, 3.75, 1.875;
    2.5, 3.125, 3.125, 3.75;
    3.75, 4.375, 4.375, 5.0]; % Rectangles with 1 solutions.
% generating the plot.
bisect2valuedRecPlot(B, K, L)
%
%%%%%%%%%%%%%
% Functions %
%%%%%%%%%%%%%
%
function bisect2valuedRecPlot(B, K, L)
    fig = figure;
    fig.Units = 'pixels';
    fig.Position(1:2) = [100, 100]; % The bottom left corner of the figure window on the computer screen. This has no effect on the plot itself.
    fig.Position(3:4) = [460, 460]; % The whole output figure size.
    for idx = 1:size(K, 1)
        fill([K(idx, 1), K(idx, 3), K(idx, 3), K(idx, 1), K(idx, 1)], [K(idx, 2), K(idx, 2), K(idx, 4), K(idx, 4), K(idx, 2)], [1, 1, 0]);
        hold on
    end
    for idx = 1:size(L, 1)
        fill([L(idx, 1), L(idx, 3), L(idx, 3), L(idx, 1), L(idx, 1)], [L(idx, 2), L(idx, 2), L(idx, 4), L(idx, 4), L(idx, 2)], [0.57, 0.88, 1]);
        hold on
    end
    axis([B(1, 1) B(1, 2) B(2, 1) B(2, 2)])
    xticks(B(1, 1):(B(1, 2)-B(1, 1))/5:B(1, 2))
    ax = gca;
    ax.XRuler.Exponent = 0;
    ax.Units='pixels';
%     ax.Position(1:2)=[50,60]; % Position of the bottom left corner of the plot inside the figure.
%     ax.Position(3:4)=[480,380]; % The size of the main plot.
    yticks(B(2, 1):(B(2, 2)-B(2, 1))/5:B(2, 2))
    xlabel('$k_7$', 'interpreter', 'latex', 'FontName', 'Times New Roman', 'FontSize', 18)
    ylabel('$k_8$', 'interpreter', 'latex', 'FontName', 'Times New Roman', 'FontSize', 18)
    set(get(gca, 'ylabel'), 'rotation', 0)
    hold off
end
%
% End of the file.